package org.msh.etbm.services.mobile.sync.server;

import org.jboss.seam.Component;
import org.msh.etbm.rest.mobile.SyncFromServerRequest;
import org.msh.etbm.services.mobile.InitAndSyncDataGenerator;
import org.msh.etbm.services.mobile.model.DeletedEntityData;
import org.msh.tb.entities.DeletedEntity;
import org.msh.tb.entities.Tbunit;

import javax.persistence.EntityManager;
import java.util.ArrayList;
import java.util.List;

public class DeletedEntityDataGenerator implements InitAndSyncDataGenerator<List<DeletedEntityData>> {

    @Override
    public List<DeletedEntityData> generate(Tbunit unit) {
        // in initialization this doesn't need to be sent, as the mobile database is empty at that point.
        return null;
    }

    @Override
    public List<DeletedEntityData> generate(Tbunit unit, SyncFromServerRequest serverIndex) {
        EntityManager em = (EntityManager) Component.getInstance("entityManager");

        List<DeletedEntity> lst = em.createQuery("from DeletedEntity de " +
                "where (de.unitToBeDeleted is null or de.unitToBeDeleted.id = :id)" +
                "and de.lastTransaction.id > :serverIndexFrom " +
                "and de.lastTransaction.id <= :serverIndexTo ")
                .setParameter("id", unit.getId())
                .setParameter("serverIndexFrom", serverIndex.getServerIndexFrom())
                .setParameter("serverIndexTo", serverIndex.getServerIndexTo())
                .getResultList();

        List<DeletedEntityData> res = new ArrayList<DeletedEntityData>();

        for (DeletedEntity de: lst) {
            res.add(convertData(de));
        }

        return res;
    }

    public static DeletedEntityData convertData(DeletedEntity de) {
        DeletedEntityData data = new DeletedEntityData();
        data.setEntityName(de.getEntityName());
        data.setEntityServerId(de.getEntityId());
        return data;
    }

}
